/**
 * \file: signature.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: authorization level daemon
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2010, 2011 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#ifndef ALD_ENCRYPTION_SIGNATURE_H
#define ALD_ENCRYPTION_SIGNATURE_H

#include <openssl/evp.h>

#include "ald_types.h"

//---------------------------------------- init and deinit ----------------------------------------------------------
error_code_t signature_init(void);

void signature_deinit(void);

//---------------------------------------- reading in and destroying keys -------------------------------------------

error_code_t signature_read_private_key(const char *path, EVP_PKEY **privkey_ptr);

error_code_t signature_read_public_key(const char *path, EVP_PKEY **pubkey_ptr, bool encrypted);

void signature_destroy_key(EVP_PKEY *key);

//---------------------------- creating, reading, writing, and destroying signatures --------------------------------
error_code_t signature_create_for_file(const char *path, char *signature, EVP_PKEY *privkey);

error_code_t signature_read_from_file(const char *path, char *signature);

error_code_t signature_create_for_data_block(void *data, size_t data_size, char *signature,
		EVP_PKEY *privkey);

error_code_t signature_write_to_file(const char *path, char *signature);

//---------------------------- checking files against signatures ----------------------------------------------------
error_code_t signature_check_file(const char *path, char *signature, EVP_PKEY *pubkey);

error_code_t signature_check_data_block(const void *data, size_t data_size,
		const char *signature, EVP_PKEY *pubkey);

#endif
